#!/bin/sh

MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_MSG=""
MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_OK=0
MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ERROR=1

MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_CODE=${MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ERROR}
MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=0


master_page_new_esxi_sc_image_path_select() {
    debug_print "in function '${FUNCNAME[0]}'"
    
    # following 3 esxi infos, $new_esxi_host_ip, $new_esxi_username, $new_esxi_password
    # defined from master_page_add_esxi.sh, 
    # queried from master_page_new_esxi_info_conf.sh
    
    tp_esxi_image_select \
        "${MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_TITLE}" \
        "${MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_TEXT}" \
        "${MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_LABEL_OK}" \
        "${MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_LABEL_CANCEL}" \
        "${new_esxi_host_ip}" \
        "${new_esxi_username}" \
        "${new_esxi_password}" \
        "${conf_sc_prefix}"
    
    debug_print "TP_ESXI_IMAGE_SELECT_RESULT_CODE: ${TP_ESXI_IMAGE_SELECT_RESULT_CODE}"
    case "${TP_ESXI_IMAGE_SELECT_RESULT_CODE}" in
    
        "${TP_ESXI_IMAGE_SELECT_RESULT_ERROR}" )
            debug_print "${TP_ESXI_IMAGE_SELECT_RESULT_MSG}"
            MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ERROR
            MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
            if [ "${TP_ESXI_IMAGE_SELECT_RESULT_MSG}" == "${TP_ESXI_IMAGE_SELECT_ERROR_DATASTORE_IS_NOT_FOUND}" ]; then
                MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_MSG=$ERROR_ESXI_CANNOT_GET_IMAGE_PATH_DATASTORE
            else
                MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_MSG=$ERROR_ESXI_CANNOT_GET_IMAGE_PATH_SC
            fi
            return
            ;;
        
        "${TP_ESXI_IMAGE_SELECT_RESULT_CANCEL}" )
            
            # dirty method, to see if only one ManagementServer. If yes, rolling -2 page
            
            local msg
            msg=`php "${CONS_BACKEND}" list_all_esxi_vmx_file \
                "${new_esxi_host_ip}" \
                "${new_esxi_username}" \
                "${new_esxi_password}" \
                "ManagementServer"`
            local ret="${?}"
            if [ "${ret}" -ne 0 ]; then
                MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ERROR
                MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=0
                MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_MSG="${msg}"
                return
            fi

            local ms_count=`echo "${msg}" | wc -l`
            if [ "${ms_count}" -eq 1 ]; then
                MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=-2
            else
                MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
            fi
            
            MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_OK
            MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
            ;;
            
        "${TP_ESXI_IMAGE_SELECT_RESULT_CTRLC}" )
            
            MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_OK
            MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
            ;;
            
        "${TP_ESXI_IMAGE_SELECT_RESULT_OK}" )
            ;;
            
        * )
            
            MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ERROR
            MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_MSG="${MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_ERROR_UNKNOWN}"
            return
            ;;
    esac

    # defined from master_page_add_esxi.sh, used by master_page_new_esxi_save_conf.sh
    new_esxi_sc_real_image_path=${TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH}
    debug_print "new_esxi_sc_real_image_path: ${TP_ESXI_IMAGE_SELECT_RESULT_IMAGE_PATH}"
    
    MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_CONF_RESULT_OK
    MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_ROLLING=1
    MASTER_PAGE_NEW_ESXI_SC_IMAGE_PATH_SELECT_RESULT_MSG=""
    

}
